/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.manytoone;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.stalactite.engine.cascade.AfterDeleteByIdSupport;
import org.codefilarete.stalactite.engine.cascade.AfterDeleteSupport;
import org.codefilarete.stalactite.engine.cascade.BeforeInsertSupport;
import org.codefilarete.stalactite.engine.configurer.onetoone.OrphanRemovalOnUpdate;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.function.Functions;
import org.codefilarete.tool.function.Predicates;

public class ManyToOneOwnedBySourceEngine<SRC, TRGT, SRCID, TRGTID, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>> {
    private final ConfiguredPersister<SRC, SRCID> sourcePersister;
    private final ConfiguredPersister<TRGT, TRGTID> targetPersister;
    private final Accessor<SRC, TRGT> targetAccessor;
    private final Mapping.ShadowColumnValueProvider<SRC, LEFTTABLE> foreignKeyValueProvider;

    public ManyToOneOwnedBySourceEngine(ConfiguredPersister<SRC, SRCID> sourcePersister, final ConfiguredPersister<TRGT, TRGTID> targetPersister, Accessor<SRC, TRGT> targetAccessor, final Map<Column<LEFTTABLE, ?>, Column<RIGHTTABLE, ?>> keyColumnsMapping) {
        this.sourcePersister = sourcePersister;
        this.targetPersister = targetPersister;
        this.targetAccessor = targetAccessor;
        final Function<Object, Object> targetIdProvider = src -> {
            Object trgt = targetAccessor.get(src);
            return trgt == null ? null : targetPersister.getMapping().getId(trgt);
        };
        this.foreignKeyValueProvider = new Mapping.ShadowColumnValueProvider<SRC, LEFTTABLE>(){

            public Set<Column<LEFTTABLE, ?>> getColumns() {
                return new HashSet(keyColumnsMapping.keySet());
            }

            public Map<Column<LEFTTABLE, ?>, ?> giveValue(SRC bean) {
                Object trgtid = targetIdProvider.apply(bean);
                Map columnValues = targetPersister.getMapping().getIdMapping().getIdentifierAssembler().getColumnValues(trgtid);
                return Maps.innerJoinOnValuesAndKeys((Map)keyColumnsMapping, (Map)columnValues);
            }
        };
    }

    public void addInsertCascade() {
        this.sourcePersister.getMapping().addShadowColumnInsert(this.foreignKeyValueProvider);
        this.sourcePersister.addInsertListener(new BeforeInsertSupport<Object, Object>(arg_0 -> this.targetPersister.persist(arg_0), arg_0 -> this.targetAccessor.get(arg_0), Objects::nonNull));
    }

    public void addUpdateCascade(boolean orphanRemoval) {
        if (orphanRemoval) {
            this.sourcePersister.addUpdateListener(new OrphanRemovalOnUpdate<SRC, TRGT>(this.targetPersister, this.targetAccessor));
        }
        this.sourcePersister.getMapping().addShadowColumnUpdate(this.foreignKeyValueProvider);
        Functions.NullProofFunction targetProviderAsFunction = new Functions.NullProofFunction(arg_0 -> this.targetAccessor.get(arg_0));
        this.sourcePersister.addUpdateListener(new UpdateListener<SRC>((Function)targetProviderAsFunction){
            private final Predicate<TRGT> newInstancePredicate = Predicates.predicate(Objects::nonNull).and(arg_0 -> ((EntityMapping)ManyToOneOwnedBySourceEngine.access$000(ManyToOneOwnedBySourceEngine.this).getMapping()).isNew(arg_0));
            final /* synthetic */ Function val$targetProviderAsFunction;
            {
                this.val$targetProviderAsFunction = function;
            }

            public void beforeUpdate(Iterable<? extends Duo<SRC, SRC>> payloads, boolean allColumnsStatement) {
                ManyToOneOwnedBySourceEngine.this.targetPersister.insert((Iterable)Iterables.stream(payloads).map(duo -> this.val$targetProviderAsFunction.apply(duo.getLeft())).filter(this.newInstancePredicate).collect(Collectors.toSet()));
            }
        });
        this.sourcePersister.addUpdateListener(new UpdateListener<SRC>(){

            public void afterUpdate(Iterable<? extends Duo<SRC, SRC>> payloads, boolean allColumnsStatement) {
                List targetsToUpdate = (List)Iterables.collect(payloads, e -> this.getTarget(e.getLeft()) != null, e -> this.getTargets(e.getLeft(), e.getRight()), ArrayList::new);
                ManyToOneOwnedBySourceEngine.this.targetPersister.update((Iterable)targetsToUpdate, allColumnsStatement);
            }

            private Duo<TRGT, TRGT> getTargets(SRC modifiedTrigger, SRC unmodifiedTrigger) {
                return new Duo(this.getTarget(modifiedTrigger), this.getTarget(unmodifiedTrigger));
            }

            private TRGT getTarget(SRC src) {
                return ManyToOneOwnedBySourceEngine.this.targetAccessor.get(src);
            }
        });
    }

    public void addDeleteCascade(boolean orphanRemoval) {
        if (orphanRemoval) {
            Predicate<Object> deletionPredicate = ((Predicate<Object>)Objects::nonNull).and(Predicates.not(arg_0 -> ((IdMapping)this.targetPersister.getMapping().getIdMapping()).isNew(arg_0)));
            this.sourcePersister.addDeleteListener(new AfterDeleteSupport<Object, Object>(arg_0 -> this.targetPersister.delete(arg_0), arg_0 -> this.targetAccessor.get(arg_0), deletionPredicate));
            this.sourcePersister.addDeleteByIdListener(new AfterDeleteByIdSupport<Object, Object>(arg_0 -> this.targetPersister.delete(arg_0), arg_0 -> this.targetAccessor.get(arg_0), deletionPredicate));
        }
    }

    public void addForeignKeyMaintainer() {
        this.sourcePersister.getMapping().addShadowColumnInsert(this.foreignKeyValueProvider);
        this.sourcePersister.getMapping().addShadowColumnUpdate(this.foreignKeyValueProvider);
    }
}

